<?php
ob_start();
include "includes/header.php";
$table_name = "playlist";
$res = $db->select($table_name, "*", "");

// Adiciona novo usuário
if (isset($_POST["submit"])) {
    unset($_POST["submit"]);

    // Verifica se o tipo está definido e é 'm3u'
    if (isset($_POST['type']) && $_POST['type'] === 'm3u') {
        $url = $_POST['url'];

        // Verifica se a URL contém '/get.php'
        if (strpos($url, '/get.php') !== false) {
            $dnsUrl = substr($url, 0, strpos($url, '/get.php'));
            $dnsUrl = rtrim($dnsUrl);
        } else {
            $dnsUrl = ''; // Garante que a variável não seja nula
        }

        // Obtém username e password
        parse_str(parse_url($url, PHP_URL_QUERY), $queryParams);
        $username = isset($queryParams['username']) ? $queryParams['username'] : '';
        $password = isset($queryParams['password']) ? $queryParams['password'] : '';

        // Gera um novo ID para dns_id
        $dns_id = generateNewDnsId();

        // Prepara os dados para inserção na tabela playlist
        $_POST['username'] = $username;
        $_POST['password'] = $password;
        $_POST['dns_id'] = $dns_id;

        // Adiciona na tabela dns
        $dnsData = [
            'id' => $dns_id,
            'title' => 'P2PLAY VIP',
            'url' => $dnsUrl
        ];

        // Insere na tabela dns
        if ($db->insert('dns', $dnsData)) {
            echo "<script>showNotification('DNS adicionado com sucesso!', 'success');</script>";
        } else {
            echo "<script>showNotification('Erro ao adicionar DNS!', 'error');</script>";
        }
    } else {
        echo "<script>showNotification('Tipo não especificado!', 'error');</script>";
    }

    // Insere os dados na tabela playlist
    $db->insert($table_name, $_POST);
    echo "<script>window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=1'</script>";
}

function generateNewDnsId() {
    global $db;
    $result = $db->select('dns', 'MAX(id) as max_id');
    return ($result[0]['max_id'] ?? 0) + 1; // Incrementa o ID máximo existente
}

// Atualiza usuário
if (isset($_GET["update"])) {
    $resU = $db->select($table_name, "*", "id = :id", "", [":id" => $_GET["update"]]);
    if ($resU) {
        $userData = $resU[0]; // Pega os dados do usuário para editar
    }
}

if (isset($_POST["submitU"])) {
    unset($_POST["submitU"]);
    $updateData = $_POST;
    $db->update($table_name, $updateData, "id = :id", [":id" => $_GET["update"]]);
    echo "<script>window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=1'</script>";
}

// Deleta usuário
if (isset($_GET["delete"])) {
    $db->delete($table_name, "id = :id", [":id" => $_GET["delete"]]);
    echo "<script>window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=2'</script>";
}

// Formulário de criação ou edição
if (isset($_GET["create"]) || isset($_GET["update"])) {
    $action = isset($_GET["update"]) ? 'Editar Usuário' : 'Adicionar Usuário';
    echo '<div class="col-12 col-md-8 mx-auto">
            <div class="card-body">
                <div class="card bg-primary text-white">
                    <div class="card-header card-header-warning text-center">
                        <h2><i class="icon icon-bullhorn"></i> ' . $action . '</h2>
                    </div>
                    <div class="card-body">
                        <form method="post">
                            <!-- Campos para seleção entre DNS e M3U -->
                            <div class="form-group">
                                <label class="form-label" for="type">Selecionar Tipo</label>
                                <select class="form-control" id="type" name="type" onchange="toggleFields()">
                                    <option value="" selected>Selecionar uma opção</option>
                                    <option value="dns"' . (isset($userData) && $userData["type"] == "dns" ? ' selected' : '') . '>Selecionar DNS</option>
                                    <option value="m3u"' . (isset($userData) && $userData["type"] == "m3u" ? ' selected' : '') . '>Selecionar M3u</option>
                                </select>
                            </div>';

   // Campos de DNS
echo '<div id="dns-fields" style="display: ' . (isset($userData) && $userData["type"] == "dns" ? 'block' : 'none') . ';">
        <div class="form-group">
            <label class="form-label" for="dns_id">DNS</label>
            <select class="form-control" name="dns_id">';
$dnss = $db->select("dns", "*", "title != :title", "", [":title" => "new"]); // Adiciona a condição para excluir "new"
foreach ($dnss as $dns) {
    echo '<option value="' . $dns["id"] . '"' . (isset($userData) && $userData["dns_id"] == $dns["id"] ? ' selected' : '') . '>' . $dns["title"] . '</option>';
}
echo '      </select>
        </div>
    </div>';

    // Campos de M3U
    echo '<div id="m3u-fields" style="display: ' . (isset($userData) && $userData["type"] == "m3u" ? 'block' : 'none') . ';">
            <div class="form-group">
                <label class="form-label" for="mac">Endereço MAC</label>
                <input class="form-control" id="mac" name="mac_address" placeholder="Endereço MAC" type="text" value="' . (isset($userData) ? $userData["mac_address"] : '') . '"/>
            </div>
            <div class="form-group">
                <label class="form-label" for="url">URL</label>
                <input class="form-control" id="url" name="url" placeholder="URL" type="text" value="' . (isset($userData) ? $userData["url"] : '') . '"/>
            </div>
        </div>';

    // Campos comuns
echo '<div id="common-fields" style="display: none;">
        <div class="form-group">
                <label class="form-label" for="mac">Endereço MAC</label>
                <input class="form-control" id="mac" name="mac_address" placeholder="Endereço MAC" type="text" value="' . (isset($userData) ? $userData["mac_address"] : '') . '"/>
            </div>
        <div class="form-group">
            <label class="form-label" for="username">Nome de Usuário</label>
            <input class="form-control" id="username" name="username" placeholder="Nome de Usuário" type="text" value="' . (isset($userData) ? $userData["username"] : '') . '"/>
        </div>
        <div class="form-group">
            <label class="form-label" for="password">Senha</label>
            <input class="form-control" id="password" name="password" placeholder="Senha" type="text" value="' . (isset($userData) ? $userData["password"] : '') . '"/>
        </div>
        <div class="form-group">
            <label class="form-label" for="pin">Parental Pin</label>
            <input class="form-control" id="pin" name="pin" placeholder="Parental Pin" type="text" value="' . (isset($userData) ? $userData["pin"] : '0000') . '"/>
        </div>
        <div class="form-group">
                <label class="form-label" for="link">Link</label>
                <input class="form-control" id="link" name="link" placeholder="Link" type="text" value="' . (isset($userData) ? $userData["link"] : '') . '"/>
            </div>
    </div>';

    // Botão de envio
    echo '<div class="form-group text-center">
            <button class="btn btn-info" name="' . (isset($_GET["update"]) ? 'submitU' : 'submit') . '" type="submit">
                <i class="icon icon-check"></i> ' . (isset($_GET["update"]) ? 'Atualizar' : 'Enviar') . '
            </button>
        </div>
    </form>
</div>
</div>
</div>
</div>';

    // Javascript para mostrar/ocultar campos
echo '<script>
   function toggleFields() {
    var type = document.getElementById("type").value;
    
    // Mostra campos comuns se um tipo for selecionado
    document.getElementById("common-fields").style.display = type ? "block" : "none"; 

    if (type === "dns") {
        document.getElementById("dns-fields").style.display = "block";
        document.getElementById("m3u-fields").style.display = "none";
        
        // Mostra os campos comuns para DNS
        document.getElementById("mac").parentElement.style.display = "block";  // Exibe o campo MAC
        document.getElementById("username").parentElement.style.display = "block";  // Exibe o campo Nome de Usuário
        document.getElementById("password").parentElement.style.display = "block";  // Exibe o campo Senha
        document.getElementById("pin").parentElement.style.display = "block";  // Exibe o campo Parental Pin
    } else if (type === "m3u") {
        document.getElementById("dns-fields").style.display = "none";
        document.getElementById("m3u-fields").style.display = "block";
        
        // Oculta os campos que não são necessários para M3U
        document.getElementById("mac").parentElement.style.display = "none";  // Esconde o campo MAC
        document.getElementById("username").parentElement.style.display = "none";  // Esconde o campo Nome de Usuário
        document.getElementById("password").parentElement.style.display = "none";  // Esconde o campo Senha
        document.getElementById("pin").parentElement.style.display = "none";  // Esconde o campo Parental Pin
    } else {
        document.getElementById("dns-fields").style.display = "none";
        document.getElementById("m3u-fields").style.display = "none";
    }
}

document.addEventListener("DOMContentLoaded", function() {
    toggleFields(); // Chama a função ao carregar a página para definir o estado inicial
});

</script>';

    
} else {
    // Exibição da lista de usuários
echo '<div class="col-12 mx-auto">
        <div class="card-body">
            <div class="card bg-primary text-white">
                <div class="card-header card-header-warning text-center">
                    <h2><i class="icon icon-bullhorn"></i> Gerenciamento de Usuários</h2>
                </div>
                <div class="card-body text-center">
                    <a href="' . basename($_SERVER["SCRIPT_NAME"]) . '?create=1" class="btn btn-info btn-sm" type="button">Adicionar Novo</a>
                    <input type="text" id="search" class="form-control mt-2" placeholder="Buscar por MAC Address" onkeyup="filterTable()">
                    <div class="table-responsive mt-2">
                        <table class="table table-striped" id="userTable">
                            <thead>
                                <tr>
                                    <th>DNS</th>
                                    <th>MAC Address</th>
                                    <th>Username</th>
                                    <th>Password</th>
                                    <th>Parental Pin</th>
                                    <th>Link</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>';
                            // Lógica para abrir o formulário ao clicar no botão "Mensagem"
if (isset($_GET['message'])) {
    $deviceId = $_GET['message'];
    $jsonFilePath = __DIR__ . '/api/device_keys.json';
    
    // Carregar os dados do JSON
    if (file_exists($jsonFilePath)) {
        $jsonData = json_decode(file_get_contents($jsonFilePath), true);
        
        if (isset($jsonData[$deviceId])) {
    $currentValue = $jsonData[$deviceId];
    echo '<form method="post" action="">
            <div style="display: flex; flex-direction: column; margin-bottom: 10px;">
                <label for="key">Cliente:</label>
                <input type="text" name="key" value="' . htmlspecialchars($deviceId) . '" readonly>
            </div>
            <div style="display: flex; flex-direction: column; margin-bottom: 10px;">
                <label for="value">Menssagem:</label>
                <input type="text" name="value" value="' . htmlspecialchars($currentValue) . '">
            </div>
            <input type="hidden" name="device_id" value="' . htmlspecialchars($deviceId) . '">
            <button type="submit" class="btn btn-success">Salvar</button>
          </form>';
} else {
            echo '<p>Dispositivo não encontrado no JSON.</p>';
        }
    } else {
        echo '<p>Arquivo JSON não encontrado.</p>';
    }
}
foreach ($res as $row) {
    echo '<tr>
            <td>' . $row["dns_id"] . '</td>
            <td>' . $row["mac_address"] . '</td>
            <td>' . $row["username"] . '</td>
            <td>' . $row["password"] . '</td>
            <td>' . $row["pin"] . '</td>
            <td>' . $row["link"] . '</td>
            <td>
                <a href="' . basename($_SERVER["SCRIPT_NAME"]) . '?update=' . $row["id"] . '" class="btn btn-warning btn-sm">Editar</a>
                <a href="' . basename($_SERVER["SCRIPT_NAME"]) . '?message=' . $row["mac_address"] . '" class="btn btn-info btn-sm">
                    <i class="fas fa-comment-dots"></i> Mensagem
                </a>
                <a href="' . basename($_SERVER["SCRIPT_NAME"]) . '?delete=' . $row["id"] . '" class="btn btn-danger btn-sm">Deletar</a>
            </td>
        </tr>';
}
echo '        </tbody>
            </table>
        </div>
    </div>
</div>
</div>';

// Lógica para salvar as edições
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['device_id'])) {
    $deviceId = $_POST['device_id'];
    $newValue = $_POST['value'];
    
    // Atualizar o JSON
    $jsonData[$deviceId] = $newValue;
    file_put_contents($jsonFilePath, json_encode($jsonData, JSON_PRETTY_PRINT));
    
    // Redirecionar após a edição
    header("Location: " . basename($_SERVER["SCRIPT_NAME"]));
    exit();
}

echo '<script>
function filterTable() {
    var input = document.getElementById("search");
    var filter = input.value.toLowerCase();
    var table = document.getElementById("userTable");
    var tr = table.getElementsByTagName("tr");

    for (var i = 1; i < tr.length; i++) {
        var td = tr[i].getElementsByTagName("td")[1]; // Coluna do MAC Address
        if (td) {
            var txtValue = td.textContent || td.innerText;
            tr[i].style.display = txtValue.toLowerCase().indexOf(filter) > -1 ? "" : "none";
        }
    }
}
</script>';

}

include "includes/footer.php";
ob_end_flush(); // Envia a saída
?>
