<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header('Location: admin_login.php');
    exit();
}

$filename = 'tokens.txt';

// Função para ler tokens do arquivo
function readTokens($filename) {
    $tokens = [];
    if (file_exists($filename)) {
        $lines = file($filename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach ($lines as $line) {
            list($token, $status) = explode('|', $line);
            $tokens[$token] = $status;
        }
    }
    return $tokens;
}

// Função para salvar tokens no arquivo
function saveTokens($filename, $tokens) {
    $lines = [];
    foreach ($tokens as $token => $status) {
        $lines[] = $token . '|' . $status;
    }
    file_put_contents($filename, implode(PHP_EOL, $lines));
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['create_token'])) {
        $token = trim($_POST['token']);
        $tokens = readTokens($filename);
        if (!isset($tokens[$token])) {
            $tokens[$token] = 'active';
            saveTokens($filename, $tokens);
            echo "Token criado com sucesso.";
        } else {
            echo "Token já existe.";
        }
    }

    if (isset($_POST['deactivate_token'])) {
        $token = trim($_POST['token']);
        $tokens = readTokens($filename);
        if (isset($tokens[$token])) {
            $tokens[$token] = 'inactive';
            saveTokens($filename, $tokens);
            echo "Token desativado com sucesso.";
        } else {
            echo "Token não encontrado.";
        }
    }
}

$tokens = readTokens($filename);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Tokens</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<div class="container">
    <h1 class="mt-5">Manage Tokens</h1>
    <form method="post" class="mt-3">
        <div class="form-group">
            <label for="token">Create New Token:</label>
            <input type="text" class="form-control" name="token" id="token" required>
        </div>
        <button type="submit" class="btn btn-primary" name="create_token">Create Token</button>
    </form>

    <h2 class="mt-5">Existing Tokens</h2>
    <table class="table mt-3">
        <thead>
            <tr>
                <th>Token</th>
                <th>Status</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($tokens as $token => $status) { ?>
                <tr>
                    <td><?= htmlspecialchars($token) ?></td>
                    <td><?= htmlspecialchars($status) ?></td>
                    <td>
                        <?php if ($status == 'active') { ?>
                            <form method="post" class="d-inline">
                                <input type="hidden" name="token" value="<?= htmlspecialchars($token) ?>">
                                <button type="submit" class="btn btn-danger" name="deactivate_token">Deactivate</button>
                            </form>
                        <?php } ?>
                    </td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
</div>
</body>
</html>
