<?php
session_start();
if (!isset($_SESSION['access_granted'])) {
    $_SESSION['access_granted'] = false;
}

$filename = 'tokens.txt';

function readTokens($filename) {
    $tokens = [];
    if (file_exists($filename)) {
        $lines = file($filename, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach ($lines as $line) {
            list($token, $status) = explode('|', $line);
            $tokens[$token] = $status;
        }
    }
    return $tokens;
}

if (isset($_POST['access_token'])) {
    $access_token = trim($_POST['access_token']);
    $tokens = readTokens($filename);

    if (isset($tokens[$access_token]) && $tokens[$access_token] === 'active') {
        $_SESSION['access_granted'] = true;
        echo 'success';
    } else {
        echo 'fail';
    }
    exit();
}

if (!$_SESSION['access_granted']) {
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Access Required</title>
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    </head>
    <body>
    <div class="modal" id="accessModal" tabindex="-1" role="dialog" aria-labelledby="accessModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="accessModalLabel">Enter Access Token</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="accessForm" method="post">
                        <div class="form-group">
                            <label for="access_token">Access Token:</label>
                            <input type="text" class="form-control" id="access_token" name="access_token" required>
                        </div>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script>
    $(document).ready(function(){
        $('#accessModal').modal({backdrop: 'static', keyboard: false});
        $('#accessModal').modal('show');

        $('#accessForm').on('submit', function(e){
            e.preventDefault();
            var access_token = $('#access_token').val();
            $.ajax({
                type: "POST",
                url: "",
                data: {access_token: access_token},
                success: function(response){
                    if(response === 'success'){
                        location.reload();
                    } else {
                        alert('Invalid Access Token');
                    }
                }
            });
        });
    });
    </script>
    </body>
    </html>
    <?php
    exit();
}
?>

<!-- Your main content goes here -->
